package w83a.w83aUtilidadesComunes;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;

import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

public abstract class W83aClsTrazas {

	private W83aClsTrazas instance = null;//NOPMD
	
	public static final Logger logger = new ConsoleLogger(ConsoleLogger.LEVEL_INFO);
	
	static String  codAplic = Q70ListenerUtils.getApplicationProperty("COD_APLICACION");//NOPMD


	public static void formatTraza(W83aUsuarioXLNetsBean usuarioBean, String traza){
		String temp = traza;
		
		while(temp.length()>100){
			traza(usuarioBean,temp.substring(0, 100));
			temp = temp.substring(100,temp.length());
		}
		traza(usuarioBean,temp);
		
	}
	
	
	/**Aade una traza de nivel de informacin.
	 * @param usuarioBean
	 * @param traza
	 */
	public static void traza(W83aUsuarioXLNetsBean usuarioBean, String traza) {//NOPMD

		if(usuarioBean !=null){
			traza = usuarioBean.getIdUsuario() +"-> "+traza; 
		}
		
		String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_W83B");
		
		Q70Factoria.getTraza().trace("W83B", Q70TraceLevel.INFO,
				traza);
		
		if("LOCAL".equals(strEntornoAplic)){
			W83aClsTrazas.logger.info(traza + "\n");
		}
		
	}
	

	/**
	 * Traza error.
	 *
	 * @param clase the clase
	 * @param cadena the cadena
	 * @param theThrowable the the throwable
	 */
	public static void trazaError(W83aUsuarioXLNetsBean usuarioBean, String cadena,Throwable theThrowable) {//NOPMD
		String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_W83B");

		if(usuarioBean !=null){
			cadena = usuarioBean.getIdUsuario() +"-> "+cadena; 
		}
		Q70Factoria.getTraza().trace(codAplic, Q70TraceLevel.ERROR,
				cadena);
		if("LOCAL".equals(strEntornoAplic)){
			W83aClsTrazas.logger.error(cadena + "\n");
		}
	}
	
	/**
	 * Traza debug.
	 *
	 * @param clase the clase
	 * @param cadena the cadena
	 * @param theThrowable the the throwable
	 */
	public static void trazaDebug(W83aUsuarioXLNetsBean usuarioBean,  String cadena) {//NOPMD
		String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_W83B");
		
		if(usuarioBean !=null){
			cadena = usuarioBean.getIdUsuario() +"-> "+cadena; 
		}
		Q70Factoria.getTraza().trace(codAplic, Q70TraceLevel.DEBUG,
				cadena);
		if("LOCAL".equals(strEntornoAplic)){
			W83aClsTrazas.logger.error(cadena + "\n");
		}
	}

}